/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Enumeration;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.WeightedInstancesHandler;

public class PeakTransformed
extends SingleClassifierEnhancer
implements WeightedInstancesHandler {
    private static final long serialVersionUID = 2483812207638252172L;
    protected Instances m_Header = null;

    public String globalInfo() {
        return "Uses the maximum peak in the instances.";
    }

    protected Instance transformInstance(Instance in) {
        double[] values = new double[2];
        Enumeration enu = in.enumerateAttributes();
        double max = Double.NEGATIVE_INFINITY;
        while (enu.hasMoreElements()) {
            Attribute att = (Attribute)enu.nextElement();
            if (att == in.classAttribute() || !(in.value(att) > max)) continue;
            max = in.value(att);
        }
        values[0] = max;
        values[1] = in.classValue();
        return new DenseInstance(1.0, values);
    }

    public void buildClassifier(Instances ins) throws Exception {
        this.getCapabilities().testWithFail(ins);
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        atts.add(new Attribute("Peak"));
        atts.add(new Attribute("Class"));
        Instances m_Data = new Instances("SumData", atts, 0);
        for (int i = 0; i < ins.numInstances(); ++i) {
            Instance inst = ins.instance(i);
            m_Data.add(this.transformInstance(inst));
        }
        m_Data.setClassIndex(1);
        this.m_Header = new Instances(m_Data, 0);
        this.m_Classifier.buildClassifier(m_Data);
    }

    public double classifyInstance(Instance inst) throws Exception {
        Instance i = this.transformInstance(inst);
        i.setDataset(this.m_Header);
        return this.m_Classifier.classifyInstance(i);
    }

    public String toString() {
        return this.m_Classifier.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1185 $");
    }

    public static void main(String[] argv) {
        PeakTransformed.runClassifier((Classifier)new PeakTransformed(), (String[])argv);
    }
}

