/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.sequence.core.Alphabet;
import weka.classifiers.sequence.core.ExtendedProteinAlphabet;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.ImpossibleStateProbabilityException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public abstract class SequenceLearner
extends AbstractClassifier
implements Serializable {
    private static final long serialVersionUID = 6502780192411755341L;
    protected int restrictSequenceLength = -1;
    protected int restrictMatchColumns = -1;
    private Alphabet alphabet = new ExtendedProteinAlphabet();
    protected double logLikelihoodThreshold;
    protected int sequenceIndex;
    protected boolean useNullModel;
    protected boolean transitionsEmissionsNotInLog;
    protected boolean learnInsertEmissions;
    private int baumWelchOption;
    private boolean memorySensitive;
    protected boolean viterbiProb;
    protected boolean fwdProb;
    protected boolean allProb;
    protected boolean allProbOnly;
    protected boolean noBasic;
    protected boolean noPathLogScores;
    private int stopAfterIteration = -1;
    protected List<Boolean> converged;
    protected int sampleMethod = -1;
    public static final int UniformBackgroundDist = -1;
    public static final int Pos4BackgroundDist = 0;
    public static final int Neg4BackgroundDist = 1;
    public static final int All4BackgroundDist = 2;
    public static final Tag[] TAGS_BackDist = new Tag[]{new Tag(-1, "UNI", "use uniform distribution as background null distribution"), new Tag(0, "POS", "use distribution of postives inst. as background null distribution"), new Tag(1, "NEG", "use distribution of negatives inst. as background null distribution"), new Tag(2, "BOTH", "use distribution of all inst. as background null distribution")};
    protected int backDist = 0;

    public int getStopAfterIteration() {
        return this.stopAfterIteration;
    }

    public void setStopAfterIteration(int stopAfterIteration) {
        this.stopAfterIteration = stopAfterIteration == -1 ? Integer.MAX_VALUE : stopAfterIteration;
    }

    public boolean isNoBasic() {
        return this.noBasic;
    }

    public void setNoBasic(boolean noBasic) {
        this.noBasic = noBasic;
    }

    public abstract Instances propositionalise(Instances var1) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException;

    public abstract Instance propositionaliseTestInstance(Instance var1) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException, ImpossibleStateProbabilityException;

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllAttributes();
        result.disableAllAttributeDependencies();
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.disable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enableDependency(Capabilities.Capability.NOMINAL_CLASS);
        result.setMinimumNumberInstances(1);
        return result;
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement(enm.nextElement());
        }
        result.addElement(new Option("\tCuts all sequences after specified length.", "L", 1, "-L "));
        result.addElement(new Option("\tRestricts the number of match states to the specified values.", "X", 1, "-X "));
        result.addElement(new Option("\tFull class name of Alphabet to use", "A", 1, "-A <Alphabet>"));
        result.addElement(new Option("\tLog likelihood threshold", "C", 1, "-C "));
        result.addElement(new Option("\tLog likelihood option for Baum-Welch: (0) overall loglikelihood, (1) average over sequence number, (2) average of all residues in all sequences (default)", "B", 1, "-B "));
        result.addElement(new Option("\tStop after the number of specified iterations instead of training to full convergence determined by log likelihood threshold", "F", 1, "-F "));
        result.addElement(new Option("\tUse NullModel", "N", 0, "-N "));
        result.addElement(new Option("\tDon't use logs for emission and transition probabilities", "E", 0, "-E "));
        result.addElement(new Option("\tFlag that indicate whether or not emission probabilities in insert states are subject to learning", "I", 0, "-I "));
        result.addElement(new Option("\tMore memory sensitive, but more time-consuming execution of BaumWelch", "S", 0, "-S "));
        result.addElement(new Option("\tThe background dist to use as null model\n\t(default: UNI)", "J", 1, "-J " + Tag.toOptionList((Tag[])TAGS_BackDist)));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        if (this.getRestrictSequenceLength() != -1) {
            result.add("-L");
            result.add("" + this.getRestrictSequenceLength());
        }
        if (this.getRestrictMatchColumns() != -1) {
            result.add("-X");
            result.add("" + this.getRestrictMatchColumns());
        }
        result.add("-A");
        result.add("" + this.getAlphabetSpec());
        result.add("-C");
        result.add("" + this.getLogLikelihoodThreshold());
        result.add("-B");
        result.add("" + this.getBaumWelchOption());
        result.add("-F");
        result.add("" + this.getStopAfterIteration());
        if (this.useNullModel) {
            result.add("-N");
        }
        if (this.transitionsEmissionsNotInLog) {
            result.add("-E");
        }
        if (this.learnInsertEmissions) {
            result.add("-I");
        }
        if (this.memorySensitive) {
            result.add("-S");
        }
        result.add("-J");
        result.add("" + this.getBackDist());
        return result.toArray(new String[result.size()]);
    }

    private String getAlphabetSpec() {
        Alphabet alpha = this.getAlphabet();
        if (alpha instanceof OptionHandler) {
            return alpha.getClass().getName() + " " + Utils.joinOptions((String[])((OptionHandler)alpha).getOptions());
        }
        return alpha.getClass().getName();
    }

    public void setOptions(String[] options) throws Exception {
        String[] alphabetSpec;
        String numberString = Utils.getOption((char)'L', (String[])options);
        this.restrictSequenceLength = numberString.length() != 0 ? Integer.parseInt(numberString) : -1;
        numberString = Utils.getOption((char)'X', (String[])options);
        this.restrictMatchColumns = numberString.length() != 0 ? Integer.parseInt(numberString) : -1;
        String alphabetString = Utils.getOption((char)'A', (String[])options);
        if (alphabetString.length() > 0) {
            alphabetSpec = Utils.splitOptions((String)alphabetString);
            if (alphabetSpec.length == 0) {
                throw new IllegalArgumentException("Invalid Alphabet specification string");
            }
        } else {
            throw new Exception("define alphabet");
        }
        String alphabetName = alphabetSpec[0];
        alphabetSpec[0] = "";
        this.setAlphabet((Alphabet)Utils.forName(Alphabet.class, (String)alphabetName, (String[])alphabetSpec));
        numberString = Utils.getOption((char)'C', (String[])options);
        if (numberString.length() != 0) {
            this.logLikelihoodThreshold = Double.parseDouble(numberString);
        }
        if ((numberString = Utils.getOption((char)'B', (String[])options)).length() != 0) {
            this.baumWelchOption = Integer.parseInt(numberString);
        }
        if (this.baumWelchOption < 0 || this.baumWelchOption > 2) {
            this.baumWelchOption = 2;
        }
        if ((numberString = Utils.getOption((char)'F', (String[])options)).length() != 0) {
            this.stopAfterIteration = Integer.parseInt(numberString);
            if (this.stopAfterIteration == -1) {
                this.stopAfterIteration = Integer.MAX_VALUE;
            }
        } else {
            this.stopAfterIteration = Integer.MAX_VALUE;
        }
        this.useNullModel = Utils.getFlag((char)'N', (String[])options);
        this.transitionsEmissionsNotInLog = Utils.getFlag((char)'E', (String[])options);
        this.learnInsertEmissions = Utils.getFlag((char)'I', (String[])options);
        this.memorySensitive = Utils.getFlag((char)'S', (String[])options);
        String tmpStr = Utils.getOption((char)'J', (String[])options);
        if (tmpStr.length() != 0) {
            this.setBackDist(new SelectedTag(tmpStr, TAGS_BackDist));
        } else {
            this.setBackDist(new SelectedTag(-1, TAGS_BackDist));
        }
        super.setOptions(options);
    }

    public SelectedTag getBackDist() {
        return new SelectedTag(this.backDist, TAGS_BackDist);
    }

    public void setBackDist(SelectedTag newBackDist) {
        if (newBackDist.getTags() == TAGS_BackDist) {
            this.backDist = newBackDist.getSelectedTag().getID();
        }
    }

    public int getRestrictSequenceLength() {
        return this.restrictSequenceLength;
    }

    public void setRestrictSequenceLength(int value) {
        this.restrictSequenceLength = value;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public void setAlphabet(Alphabet alphabet) {
        this.alphabet = alphabet;
    }

    public String alphabetTipText() {
        return "The alphabet to use.";
    }

    public double getLogLikelihoodThreshold() {
        return this.logLikelihoodThreshold;
    }

    public void setLogLikelihoodThreshold(double logLikelihoodThreshold) {
        this.logLikelihoodThreshold = logLikelihoodThreshold;
    }

    public String logLikelihoodThresholdTipText() {
        return "The threshold for convergence for the log likelihood using the Baum-Welch algorithm.";
    }

    public boolean isUseNullModel() {
        return this.useNullModel;
    }

    public void setUseNullModel(boolean useNullModel) {
        this.useNullModel = useNullModel;
    }

    public String useNullModelTipText() {
        return "All scores are log-odds. A NullModel is used";
    }

    public boolean getTransitionsEmissionsNotInLog() {
        return this.transitionsEmissionsNotInLog;
    }

    public void setTransitionsEmissionsNotInLog(boolean transitionsEmissionsNotInLog) {
        this.transitionsEmissionsNotInLog = transitionsEmissionsNotInLog;
    }

    public boolean isLearnInsertEmissions() {
        return this.learnInsertEmissions;
    }

    public void setLearnInsertEmissions(boolean learnInsertEmissions) {
        this.learnInsertEmissions = learnInsertEmissions;
    }

    public String learnInsertEmissionsTipText() {
        return "Flag that indicate whether or not emission probabilities in insert states are subject to learning";
    }

    protected Instances doPropositionalisation(String[] allAlignment, Instances transformed, double classValue) throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        DenseInstance newInst = new DenseInstance(transformed.numAttributes());
        newInst.setDataset(transformed);
        newInst.setClassValue(classValue);
        int attributeCounter = 0;
        for (int k = 0; k < allAlignment.length; ++k) {
            String alignment = allAlignment[k];
            for (int i = 0; i < alignment.length(); ++i) {
                if (alignment.charAt(i) == '-') {
                    newInst.setValue(attributeCounter, "-");
                    newInst.setValue(++attributeCounter, 0.0);
                    ++attributeCounter;
                    continue;
                }
                if (Character.isUpperCase(alignment.charAt(i))) {
                    newInst.setValue(attributeCounter, alignment.charAt(i) + "");
                    ++attributeCounter;
                }
                if (i < alignment.length() - 1 && Character.isLowerCase(alignment.charAt(i + 1))) {
                    ++i;
                    int count = 0;
                    while (i < alignment.length() && Character.isLowerCase(alignment.charAt(i))) {
                        ++i;
                        ++count;
                    }
                    --i;
                    newInst.setValue(attributeCounter, (double)count);
                    ++attributeCounter;
                    continue;
                }
                if (i >= alignment.length() - 1) continue;
                newInst.setValue(attributeCounter, 0.0);
                ++attributeCounter;
            }
        }
        transformed.add((Instance)newInst);
        newInst = null;
        return transformed;
    }

    public int getBaumWelchOption() {
        return this.baumWelchOption;
    }

    public void setBaumWelchOption(int baumWelchOption) {
        this.baumWelchOption = baumWelchOption;
    }

    public String baumWelchOptionTipText() {
        return "Log likelihood option for Baum-Welch: (0) overall loglikelihood (default), (1) average over sequence number, (2) average of all residues in all sequences";
    }

    public boolean isMemorySensitive() {
        return this.memorySensitive;
    }

    public void setMemorySensitive(boolean memorySensitive) {
        this.memorySensitive = memorySensitive;
    }

    public String memorySensitiveTipText() {
        return "More memory sensitive, but more time-consuming execution of BaumWelch";
    }

    public boolean isAllProb() {
        return this.allProb;
    }

    public void setAllProb(boolean allProb) {
        this.allProb = allProb;
    }

    public boolean isFwdProb() {
        return this.fwdProb;
    }

    public void setFwdProb(boolean fwdProb) {
        this.fwdProb = fwdProb;
    }

    public boolean isViterbiProb() {
        return this.viterbiProb;
    }

    public void setViterbiProb(boolean viterbiProb) {
        this.viterbiProb = viterbiProb;
    }

    public boolean isAllProbOnly() {
        return this.allProbOnly;
    }

    public void setAllProbOnly(boolean allProbOnly) {
        this.allProbOnly = allProbOnly;
    }

    public List<Boolean> getConverged() {
        return this.converged;
    }

    protected static double logplus(double plog, double qlog) {
        double diff;
        double max;
        if (plog > qlog) {
            if (qlog == Double.NEGATIVE_INFINITY) {
                return plog;
            }
            max = plog;
            diff = qlog - plog;
        } else {
            if (plog == Double.NEGATIVE_INFINITY) {
                return qlog;
            }
            max = qlog;
            diff = plog - qlog;
        }
        return max + (diff < -37.0 ? 0.0 : Math.log(1.0 + Math.exp(diff)));
    }

    protected static double logsum(double alog, double blog) {
        if (alog == Double.NEGATIVE_INFINITY || blog == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return alog + blog;
    }

    public boolean isNoPathLogScores() {
        return this.noPathLogScores;
    }

    public void setNoPathLogScores(boolean noPathLogScores) {
        this.noPathLogScores = noPathLogScores;
    }

    public int getRestrictMatchColumns() {
        return this.restrictMatchColumns;
    }

    public void setRestrictMatchColumns(int numberOfMatchColumns) {
        this.restrictMatchColumns = numberOfMatchColumns;
    }

    public int getSampleMethod() {
        return this.sampleMethod;
    }

    public void setSampleMethod(int sampleMethod) {
        this.sampleMethod = sampleMethod;
    }
}

