/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.KerberosName;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Credentials;
import sun.security.krb5.PrincipalName;

public class SecurityUtil {
    public static final Log LOG = LogFactory.getLog(SecurityUtil.class);
    public static final String HOSTNAME_PATTERN = "_HOST";
    private static boolean useIpForTokenService;

    static void setTokenServiceUseIp(boolean flag) {
        useIpForTokenService = flag;
        NetUtils.setUseQualifiedHostResolver(!flag);
    }

    public static boolean getTokenServiceUseIp() {
        return useIpForTokenService;
    }

    private static KerberosTicket getTgtFromSubject() throws IOException {
        Subject current = Subject.getSubject(AccessController.getContext());
        if (current == null) {
            throw new IOException("Can't get TGT from current Subject, because it is null");
        }
        Set<KerberosTicket> tickets = current.getPrivateCredentials(KerberosTicket.class);
        for (KerberosTicket t : tickets) {
            if (!SecurityUtil.isOriginalTGT(t.getServer().getName())) continue;
            return t;
        }
        throw new IOException("Failed to find TGT from current Subject:" + current);
    }

    protected static boolean isOriginalTGT(String name) {
        if (name == null) {
            return false;
        }
        String[] components = name.split("[/@]");
        return components.length == 3 && "krbtgt".equals(components[0]) && components[1].equals(components[2]);
    }

    public static void fetchServiceTicket(URL remoteHost) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String serviceName = "host/" + remoteHost.getHost();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching service ticket for host at: " + serviceName));
        }
        Credentials serviceCred = null;
        try {
            PrincipalName principal = new PrincipalName(serviceName, 3);
            serviceCred = Credentials.acquireServiceCreds(principal.toString(), Krb5Util.ticketToCreds(SecurityUtil.getTgtFromSubject()));
        }
        catch (Exception e) {
            throw new IOException("Can't get service ticket for: " + serviceName, e);
        }
        if (serviceCred == null) {
            throw new IOException("Can't get service ticket for " + serviceName);
        }
        Subject.getSubject(AccessController.getContext()).getPrivateCredentials().add(Krb5Util.credsToTicket(serviceCred));
    }

    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtil.replacePattern(components, hostname);
    }

    public static String getServerPrincipal(String principalConfig, InetAddress addr) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        if (addr == null) {
            throw new IOException("Can't replace _HOST pattern since client address is null");
        }
        return SecurityUtil.replacePattern(components, addr.getCanonicalHostName());
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.equals("") || fqdn.equals("0.0.0.0")) {
            fqdn = SecurityUtil.getLocalHostName();
        }
        return components[0] + "/" + fqdn + "@" + components[2];
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName());
    }

    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null) {
            return;
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal(principalConfig, hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static InetSocketAddress getTokenServiceAddr(Token<?> token) {
        return NetUtils.createSocketAddr(token.getService().toString());
    }

    public static void setTokenService(Token<?> token, InetSocketAddress addr) {
        token.setService(SecurityUtil.buildTokenService(addr));
    }

    public static Text buildTokenService(InetSocketAddress addr) {
        String host = null;
        if (useIpForTokenService) {
            if (addr.isUnresolved()) {
                throw new IllegalArgumentException(new UnknownHostException(addr.getHostName()));
            }
            host = addr.getAddress().getHostAddress();
        } else {
            host = addr.getHostName().toLowerCase();
        }
        return new Text(host + ":" + addr.getPort());
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        String authority = uri.getAuthority();
        if (authority == null || authority.isEmpty()) {
            return null;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(authority, defPort);
        return SecurityUtil.buildTokenService(addr).toString();
    }

    public static AccessControlList getAdminAcls(Configuration conf, String configKey) {
        try {
            AccessControlList adminAcl = new AccessControlList(conf.get(configKey, " "));
            adminAcl.addUser(UserGroupInformation.getCurrentUser().getShortUserName());
            return adminAcl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getHostFromPrincipal(String principalName) {
        return new KerberosName(principalName).getHostName();
    }

    static {
        boolean useIp = new Configuration().getBoolean("hadoop.security.token.service.use_ip", true);
        SecurityUtil.setTokenServiceUseIp(useIp);
    }
}

