/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.doublematrix.calculation.general.misc;

import org.ujmp.core.Matrix;
import org.ujmp.core.MatrixFactory;
import org.ujmp.core.doublematrix.DoubleMatrix;
import org.ujmp.core.doublematrix.calculation.AbstractDoubleCalculation;
import org.ujmp.core.doublematrix.calculation.general.statistical.Max;
import org.ujmp.core.doublematrix.calculation.general.statistical.Min;
import org.ujmp.core.exceptions.MatrixException;

public class Normalize
extends AbstractDoubleCalculation {
    private static final long serialVersionUID = -1898669824045141350L;
    private Matrix ret = null;

    public Normalize(int dimension, Matrix matrix) {
        super(dimension, matrix);
    }

    public double getDouble(long ... coordinates) throws MatrixException {
        if (this.ret == null) {
            DoubleMatrix max = new Max(this.getDimension(), this.getSource()).calcNew();
            DoubleMatrix min = new Min(this.getDimension(), this.getSource()).calcNew();
            Matrix range = max.minus(min);
            Matrix diff = null;
            switch (this.getDimension()) {
                case 0: {
                    diff = this.getSource().minus(MatrixFactory.vertCat((Matrix)min, this.getSource().getRowCount()));
                    break;
                }
                case 1: {
                    diff = this.getSource().minus(MatrixFactory.horCat((Matrix)min, this.getSource().getColumnCount()));
                    break;
                }
                default: {
                    diff = this.getSource().minus(min);
                }
            }
            switch (this.getDimension()) {
                case 0: {
                    this.ret = diff.divide(MatrixFactory.vertCat(range, this.getSource().getRowCount()));
                    break;
                }
                case 1: {
                    this.ret = diff.divide(MatrixFactory.horCat(range, this.getSource().getColumnCount()));
                    break;
                }
                default: {
                    this.ret = diff.divide(range);
                }
            }
        }
        return this.ret.getAsDouble(coordinates);
    }
}

