/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.floatmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DefaultDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.floatmatrix.stub.AbstractDenseFloatMatrix2D;
import org.ujmp.core.interfaces.HasFloatArray;

public class DefaultDenseFloatMatrix2D
extends AbstractDenseFloatMatrix2D
implements HasFloatArray {
    private static final long serialVersionUID = -5449462775185759895L;
    private float[] values = null;
    private long[] size = null;
    private int rows = 0;
    private int cols = 0;

    public DefaultDenseFloatMatrix2D(Matrix m) throws MatrixException {
        this.rows = (int)m.getRowCount();
        this.cols = (int)m.getColumnCount();
        this.size = new long[]{this.rows, this.cols};
        if (m instanceof DefaultDenseFloatMatrix2D) {
            float[] v = ((DefaultDenseFloatMatrix2D)m).values;
            this.values = new float[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new float[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setFloat(m.getAsFloat(c), c);
            }
        }
    }

    public DefaultDenseFloatMatrix2D(long ... size) {
        this.rows = (int)size[0];
        this.cols = (int)size[1];
        this.size = new long[]{this.rows, this.cols};
        this.values = new float[this.rows * this.cols];
    }

    public DefaultDenseFloatMatrix2D(float[] v, int rows, int cols) {
        this.rows = rows;
        this.cols = cols;
        this.size = new long[]{rows, cols};
        this.values = v;
    }

    public long[] getSize() {
        return this.size;
    }

    public long getRowCount() {
        return this.rows;
    }

    public long getColumnCount() {
        return this.cols;
    }

    public float getFloat(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setFloat(float value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public float getFloat(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setFloat(float value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix plus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] + v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix minus(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] - v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix times(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] * v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix divide(double v) {
        double[] result = new double[this.values.length];
        int i = result.length;
        while (--i != -1) {
            result[i] = (double)this.values[i] / v;
        }
        return new DefaultDenseDoubleMatrix2D(result, this.rows, this.cols);
    }

    public final Matrix copy() throws MatrixException {
        float[] result = new float[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseFloatMatrix2D m = new DefaultDenseFloatMatrix2D(result, this.rows, this.cols);
        if (this.getAnnotation() != null) {
            m.setAnnotation(this.getAnnotation().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        float[] result = new float[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseFloatMatrix2D(result, this.cols, this.rows);
    }

    public float[] getFloatArray() {
        return this.values;
    }
}

