/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.io;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ujmp.core.Matrix;
import org.ujmp.core.enums.FileFormat;
import org.ujmp.core.exceptions.MatrixException;

public abstract class ExportMatrix {
    public static final void toFile(File file, Matrix m, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(ExportMatrix.guessFormat(file), file, m, parameters);
    }

    public static final void toFile(String file, Matrix m, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(ExportMatrix.guessFormat(new File(file)), file, m, parameters);
    }

    public static final void toFile(FileFormat format, String filename, Matrix matrix, Object ... parameters) throws MatrixException, IOException {
        ExportMatrix.toFile(format, new File(filename), matrix, parameters);
    }

    public static final void toFile(FileFormat format, File file, Matrix matrix, Object ... parameters) throws MatrixException, IOException {
        try {
            File dir = file.getParentFile();
            if (dir != null && !dir.exists()) {
                dir.mkdirs();
            }
            Class<?> c = Class.forName("org.ujmp.core.io.ExportMatrix" + format.name());
            Method m = c.getMethod("toFile", File.class, Matrix.class, Object[].class);
            m.invoke(null, file, matrix, parameters);
        }
        catch (ClassNotFoundException e) {
            throw new MatrixException("file format not supported: " + (Object)((Object)format), e);
        }
        catch (NoSuchMethodException e) {
            throw new MatrixException("file format not supported: " + (Object)((Object)format), e);
        }
        catch (IllegalAccessException e) {
            throw new MatrixException("file format not supported: " + (Object)((Object)format), e);
        }
        catch (InvocationTargetException e) {
            throw new MatrixException("error exporting matrix in format: " + (Object)((Object)format), e);
        }
    }

    public static FileFormat guessFormat(File file) {
        String filename = file.getAbsolutePath();
        String[] components = filename.split("\\.");
        String suffix = components[components.length - 1];
        if (suffix.equalsIgnoreCase("gz") || suffix.equalsIgnoreCase("z") || suffix.equalsIgnoreCase("gzip") || suffix.equalsIgnoreCase(".zip") || suffix.equalsIgnoreCase(".7zip") || suffix.equalsIgnoreCase(".7z")) {
            suffix = components[components.length - 2];
        }
        FileFormat[] fileFormatArray = FileFormat.values();
        int n = fileFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileFormat f = fileFormatArray[n2];
            if (suffix.equalsIgnoreCase(f.name())) {
                return f;
            }
            ++n2;
        }
        throw new MatrixException("could not guess file format, please use exportToFile(Format,File,Matrix)");
    }

    public static final String toString(FileFormat format, Matrix matrix, Object ... parameters) throws MatrixException, IOException {
        StringWriter writer = new StringWriter();
        ExportMatrix.toWriter(format, writer, matrix, parameters);
        writer.close();
        return writer.toString();
    }

    public static final void toClipboard(FileFormat format, Matrix matrix, Object ... parameters) throws MatrixException, IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ms = new StringSelection(ExportMatrix.toString(format, matrix, parameters));
        clipboard.setContents(ms, ms);
    }

    public static final void toStream(FileFormat format, OutputStream outputStream, Matrix matrix, Object ... parameters) throws IOException {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.ExportMatrix" + format.name());
            Method m = c.getMethod("toStream", OutputStream.class, Matrix.class, Object[].class);
            m.invoke(null, outputStream, matrix, parameters);
        }
        catch (Exception e) {
            throw new MatrixException("stream format not supported: " + (Object)((Object)format), e);
        }
    }

    public static final void toWriter(FileFormat format, Writer writer, Matrix matrix, Object ... parameters) {
        try {
            Class<?> c = Class.forName("org.ujmp.core.io.ExportMatrix" + format.name());
            Method m = c.getMethod("toWriter", Writer.class, Matrix.class, Object[].class);
            m.invoke(null, writer, matrix, parameters);
        }
        catch (Exception e) {
            throw new MatrixException("writer format not supported: " + (Object)((Object)format), e);
        }
    }
}

