/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sortable<C extends Comparable<C>, O>
implements Comparable<Sortable<C, O>> {
    private C comparable = null;
    private O object = null;
    private boolean compareObject = false;

    public Sortable(C comparable, O object) {
        this.comparable = comparable;
        this.object = object;
    }

    public Sortable(C comparable, O object, boolean compareObject) {
        this.comparable = comparable;
        this.object = object;
        this.compareObject = compareObject;
    }

    public C getComparable() {
        return this.comparable;
    }

    public void setComparable(C comparable) {
        this.comparable = comparable;
    }

    public O getObject() {
        return this.object;
    }

    public void setObject(O object) {
        this.object = object;
    }

    public String toString() {
        return this.comparable + ": " + this.object;
    }

    @Override
    public int compareTo(Sortable<C, O> s) {
        if (this.comparable == null) {
            return Integer.MIN_VALUE;
        }
        int compObjectEqual = this.comparable.compareTo(s.comparable);
        if (!this.compareObject || compObjectEqual != 0) {
            return compObjectEqual;
        }
        if (this.object == null) {
            return Integer.MIN_VALUE;
        }
        return ((Comparable)this.object).compareTo(s.object);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Sortable) {
            Sortable s = (Sortable)obj;
            C c = s.getComparable();
            O o = s.getObject();
            if (this.comparable == null && c != null) {
                return false;
            }
            if (this.comparable.equals(c)) {
                return false;
            }
            if (this.object == null && o != null) {
                return false;
            }
            return !this.object.equals(o);
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        if (this.object != null) {
            hash += this.object.hashCode();
        }
        return hash;
    }
}

