/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.mantissa;

import org.spaceroots.mantissa.linalg.GeneralMatrix;
import org.spaceroots.mantissa.linalg.GeneralSquareMatrix;
import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.SquareMatrix;
import org.ujmp.core.Coordinates;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.exceptions.MatrixException;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.util.UJMPSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MantissaDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Matrix> {
    private static final long serialVersionUID = 6954233090244549806L;
    private Matrix matrix = null;

    public MantissaDenseDoubleMatrix2D(Matrix m) {
        this.matrix = m;
    }

    public MantissaDenseDoubleMatrix2D(long ... size) {
        if (size[0] > 0L && size[1] > 0L) {
            this.matrix = size[0] == size[1] ? new GeneralSquareMatrix((int)size[0]) : new GeneralMatrix((int)size[0], (int)size[1]);
        }
    }

    public MantissaDenseDoubleMatrix2D(org.ujmp.core.Matrix source) throws MatrixException {
        this(source.getSize());
        for (long[] c : source.availableCoordinates()) {
            this.setDouble(source.getAsDouble(c), c);
        }
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.getElement((int)row, (int)column);
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.getElement(row, column);
    }

    @Override
    public long[] getSize() {
        long[] lArray;
        if (this.matrix == null) {
            lArray = Coordinates.ZERO2D;
        } else {
            long[] lArray2 = new long[2];
            lArray2[0] = this.matrix.getRows();
            lArray = lArray2;
            lArray2[1] = this.matrix.getColumns();
        }
        return lArray;
    }

    @Override
    public void setDouble(double value, long row, long column) {
        this.matrix.setElement((int)row, (int)column, value);
    }

    @Override
    public void setDouble(double value, int row, int column) {
        this.matrix.setElement(row, column, value);
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new MantissaDenseDoubleMatrix2D(this.matrix.getTranspose());
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        if (this.matrix instanceof SquareMatrix) {
            try {
                return new MantissaDenseDoubleMatrix2D((Matrix)((SquareMatrix)this.matrix).getInverse(UJMPSettings.getTolerance()));
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (this.matrix instanceof SquareMatrix && b instanceof MantissaDenseDoubleMatrix2D) {
            try {
                Matrix b2 = ((MantissaDenseDoubleMatrix2D)b).getWrappedObject();
                return new MantissaDenseDoubleMatrix2D(((SquareMatrix)this.matrix).solve(b2, UJMPSettings.getTolerance()));
            }
            catch (Exception e) {
                throw new MatrixException(e);
            }
        }
        throw new MatrixException("only allowed for square matrices");
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix m) {
        if (m instanceof MantissaDenseDoubleMatrix2D) {
            return new MantissaDenseDoubleMatrix2D(this.matrix.mul(((MantissaDenseDoubleMatrix2D)m).getWrappedObject()));
        }
        return super.mtimes(m);
    }

    @Override
    public Matrix getWrappedObject() {
        return this.matrix;
    }

    @Override
    public void setWrappedObject(Matrix object) {
        this.matrix = object;
    }
}

