/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.base.BaseURL;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.net.URL;

public class SingleURLSupplier
extends AbstractSource {
    private static final long serialVersionUID = -6097873410185340633L;
    protected BaseURL m_URL;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Supplies a single URL (uniform resource locator).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new BaseURL());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("URL");
        if (variable != null) {
            return variable;
        }
        if (this.m_URL != null) {
            return this.m_URL.toString();
        }
        return null;
    }

    public Class[] generates() {
        return new Class[]{URL.class};
    }

    public void setURL(BaseURL value) {
        this.m_URL = value;
    }

    public BaseURL getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL (uniform resource locator) to supply.";
    }

    protected String doExecute() {
        this.m_OutputToken = new Token((Object)this.m_URL.urlValue());
        return null;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_OutputToken = null;
    }
}

