/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.Add;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TestSetProducer;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.TrainingSetProducer;
import weka.gui.beans.Visible;

@KFStep(category="Tools", toolTipText="Label instances according to substring matches in String attributes")
public class SubstringLabeler
extends JPanel
implements BeanCommon,
Visible,
Serializable,
InstanceListener,
TrainingSetListener,
TestSetListener,
DataSourceListener,
EventConstraints,
EnvironmentHandler,
DataSource {
    private static final long serialVersionUID = 6297059699297260134L;
    protected transient Environment m_env;
    protected String m_matchDetails = "";
    protected transient List<Match> m_matchRules;
    protected transient Logger m_log;
    protected transient boolean m_busy;
    protected Object m_listenee;
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected ArrayList<DataSourceListener> m_dataListeners = new ArrayList();
    protected boolean m_nominalBinary;
    protected boolean m_consumeNonMatchingInstances;
    protected boolean m_hasLabels;
    protected Add m_addFilter;
    protected String m_attName = "Match";
    protected Instances m_outputStructure;
    protected InstanceEvent m_ie = new InstanceEvent(this);
    protected BeanVisual m_visual = new BeanVisual("SubstringLabeler", "weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");

    public SubstringLabeler() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_env = Environment.getSystemWide();
    }

    public String globalInfo() {
        return "Matches substrings in String attributes using either literal or regular expression matches. The value of a new attribute is set to reflect the status of the match. The new attribute can be either binary (in which case values indicate match or no match) or multi-valued nominal, in which case a label must be associated with each distinct matching rule. In the case of labeled matches, the user can opt to have non matching instances output with missing value set for the new attribute or not output at all (i.e. consumed by the step).";
    }

    public void setMatchDetails(String details) {
        this.m_matchDetails = details;
    }

    public String getMatchDetails() {
        return this.m_matchDetails;
    }

    public void setNominalBinary(boolean nom) {
        this.m_nominalBinary = nom;
    }

    public boolean getNominalBinary() {
        return this.m_nominalBinary;
    }

    public void setConsumeNonMatching(boolean consume) {
        this.m_consumeNonMatchingInstances = consume;
    }

    public boolean getConsumeNonMatching() {
        return this.m_consumeNonMatchingInstances;
    }

    public void setMatchAttributeName(String name) {
        this.m_attName = name;
    }

    public String getMatchAttributeName() {
        return this.m_attName;
    }

    @Override
    public void addDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.add(dsl);
    }

    @Override
    public void removeDataSourceListener(DataSourceListener dsl) {
        this.m_dataListeners.remove(dsl);
    }

    @Override
    public void addInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.add(dsl);
    }

    @Override
    public void removeInstanceListener(InstanceListener dsl) {
        this.m_instanceListeners.remove(dsl);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        EventConstraints ec;
        if (this.m_listenee == null) {
            return false;
        }
        if (!eventName.equals("instance") && !eventName.equals("dataSet")) {
            return false;
        }
        if (this.m_listenee instanceof DataSource && this.m_listenee instanceof EventConstraints) {
            EventConstraints ec2 = (EventConstraints)this.m_listenee;
            return ec2.eventGeneratable(eventName);
        }
        if (this.m_listenee instanceof TrainingSetProducer && this.m_listenee instanceof EventConstraints) {
            ec = (EventConstraints)this.m_listenee;
            if (!eventName.equals("dataSet")) {
                return false;
            }
            if (!ec.eventGeneratable("trainingSet")) {
                return false;
            }
        }
        if (this.m_listenee instanceof TestSetProducer && this.m_listenee instanceof EventConstraints) {
            ec = (EventConstraints)this.m_listenee;
            if (!eventName.equals("dataSet")) {
                return false;
            }
            if (!ec.eventGeneratable("testSet")) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/DefaultFilter.gif", "weka/gui/beans/icons/DefaultFilter_animated.gif");
        this.m_visual.setText("SubstringLabeler");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void stop() {
        if (this.m_listenee != null && this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Stopped");
        }
        this.m_busy = false;
    }

    @Override
    public boolean isBusy() {
        return this.m_busy;
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        if (!eventName.equals("instance") && !eventName.equals("dataSet")) {
            return false;
        }
        return this.m_listenee == null;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
        if (source == this.m_listenee) {
            this.m_listenee = null;
        }
    }

    protected void makeOutputStructure(Instances inputStructure) throws Exception {
        this.m_matchRules = new ArrayList<Match>();
        if (this.m_matchDetails != null && this.m_matchDetails.length() > 0) {
            String[] matchParts;
            for (String p : matchParts = this.m_matchDetails.split("@@match-rule@@")) {
                Match m = new Match(p.trim());
                m.m_statusMessagePrefix = this.statusMessagePrefix();
                m.m_logger = this.m_log;
                m.init(this.m_env, inputStructure);
                this.m_matchRules.add(m);
            }
            int labelCount = 0;
            HashSet<String> uniqueLabels = new HashSet<String>();
            FastVector<String> labelVec = new FastVector<String>();
            for (Match m : this.m_matchRules) {
                if (m.getLabel() == null || m.getLabel().length() <= 0) continue;
                if (!uniqueLabels.contains(m.getLabel())) {
                    uniqueLabels.add(m.getLabel());
                    labelVec.addElement(m.getLabel());
                }
                ++labelCount;
            }
            if (labelCount > 0) {
                if (labelCount == this.m_matchRules.size()) {
                    this.m_hasLabels = true;
                } else {
                    throw new Exception("Can't have only some rules with a label!");
                }
            }
            this.m_outputStructure = (Instances)new SerializedObject(inputStructure).getObject();
            Attribute newAtt = null;
            if (this.m_hasLabels) {
                newAtt = new Attribute(this.m_attName, labelVec);
            } else if (this.getNominalBinary()) {
                labelVec.addElement("0");
                labelVec.addElement("1");
                newAtt = new Attribute(this.m_attName, labelVec);
            } else {
                newAtt = new Attribute(this.m_attName);
            }
            this.m_outputStructure.insertAttributeAt(newAtt, this.m_outputStructure.numAttributes());
            return;
        }
        this.m_outputStructure = new Instances(inputStructure);
    }

    @Override
    public void acceptInstance(InstanceEvent e) {
        this.m_busy = true;
        if (e.getStatus() == 0) {
            Instances structure = e.getStructure();
            try {
                this.makeOutputStructure(structure);
            }
            catch (Exception ex) {
                String msg = this.statusMessagePrefix() + "ERROR: unable to create output instances structure.";
                if (this.m_log != null) {
                    this.m_log.statusMessage(msg);
                    this.m_log.logMessage("[SubstringLabeler] " + ex.getMessage());
                }
                this.stop();
                ex.printStackTrace();
                this.m_busy = false;
                return;
            }
            if (this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Processing stream...");
            }
            this.m_ie.setStructure(this.m_outputStructure);
            this.notifyInstanceListeners(this.m_ie);
        } else {
            Instance inst = e.getInstance();
            Instance out = null;
            if (inst != null) {
                out = this.makeOutputInstance(inst, false);
            }
            if (inst == null || out != null || e.getStatus() == 2) {
                this.m_ie.setInstance(out);
                this.m_ie.setStatus(e.getStatus());
                this.notifyInstanceListeners(this.m_ie);
            }
            if ((e.getStatus() == 2 || inst == null) && this.m_log != null) {
                this.m_log.statusMessage(this.statusMessagePrefix() + "Finished");
            }
        }
        this.m_busy = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Instance makeOutputInstance(Instance inputI, boolean batch) {
        Match m;
        int newAttIndex = this.m_outputStructure.numAttributes() - 1;
        Instance result = inputI;
        if (this.m_matchRules.size() <= 0) return result;
        String label = null;
        Iterator<Match> i$ = this.m_matchRules.iterator();
        while (i$.hasNext() && (label = (m = i$.next()).apply(inputI)) == null) {
        }
        double[] vals = new double[this.m_outputStructure.numAttributes()];
        for (int i = 0; i < inputI.numAttributes(); ++i) {
            String v;
            if (!inputI.attribute(i).isString()) {
                vals[i] = inputI.value(i);
                continue;
            }
            if (!batch) {
                vals[i] = 0.0;
                v = inputI.stringValue(i);
                this.m_outputStructure.attribute(i).setStringValue(v);
                continue;
            }
            v = inputI.stringValue(i);
            vals[i] = this.m_outputStructure.attribute(i).addStringValue(v);
        }
        if (label != null) {
            vals[newAttIndex] = this.m_hasLabels ? (double)this.m_outputStructure.attribute(this.m_attName).indexOfValue(label) : 1.0;
        } else if (this.m_hasLabels) {
            if (this.getConsumeNonMatching()) return null;
            vals[newAttIndex] = Utils.missingValue();
        } else {
            vals[newAttIndex] = 0.0;
        }
        result = new DenseInstance(1.0, vals);
        result.setDataset(this.m_outputStructure);
        return result;
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        this.m_busy = true;
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Processing batch...");
        }
        try {
            this.makeOutputStructure(new Instances(e.getDataSet(), 0));
        }
        catch (Exception ex) {
            String msg = this.statusMessagePrefix() + "ERROR: unable to create output instances structure.";
            if (this.m_log != null) {
                this.m_log.statusMessage(msg);
                this.m_log.logMessage("[SubstringLabeler] " + ex.getMessage());
            }
            this.stop();
            ex.printStackTrace();
            this.m_busy = false;
            return;
        }
        Instances toProcess = e.getDataSet();
        for (int i = 0; i < toProcess.numInstances(); ++i) {
            Instance current = toProcess.instance(i);
            Instance result = this.makeOutputInstance(current, true);
            if (result == null) continue;
            this.m_outputStructure.add(result);
        }
        if (this.m_log != null) {
            this.m_log.statusMessage(this.statusMessagePrefix() + "Finished.");
        }
        DataSetEvent d = new DataSetEvent(this, this.m_outputStructure);
        this.notifyDataListeners(d);
        this.m_busy = false;
    }

    @Override
    public void acceptTestSet(TestSetEvent e) {
        Instances test = e.getTestSet();
        DataSetEvent d = new DataSetEvent(this, test);
        this.acceptDataSet(d);
    }

    @Override
    public void acceptTrainingSet(TrainingSetEvent e) {
        Instances train = e.getTrainingSet();
        DataSetEvent d = new DataSetEvent(this, train);
        this.acceptDataSet(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDataListeners(DataSetEvent e) {
        List l;
        SubstringLabeler substringLabeler = this;
        synchronized (substringLabeler) {
            l = (List)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            for (DataSourceListener ds : l) {
                ds.acceptDataSet(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyInstanceListeners(InstanceEvent e) {
        List l;
        SubstringLabeler substringLabeler = this;
        synchronized (substringLabeler) {
            l = (List)this.m_instanceListeners.clone();
        }
        if (l.size() > 0) {
            for (InstanceListener il : l) {
                il.acceptInstance(e);
            }
        }
    }

    protected String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    protected static class Match {
        protected String m_match = "";
        protected String m_label = "";
        protected boolean m_regex;
        protected boolean m_ignoreCase;
        protected String m_attsToApplyTo = "";
        protected String m_matchS;
        protected String m_labelS;
        protected int[] m_selectedAtts;
        protected String m_statusMessagePrefix;
        protected Logger m_logger;

        public Match() {
        }

        public Match(String setup) {
            this.parseFromInternal(setup);
        }

        public Match(String match, boolean regex, boolean ignoreCase, String selectedAtts) {
            this.m_match = match;
            this.m_regex = regex;
            this.m_ignoreCase = ignoreCase;
            this.m_attsToApplyTo = selectedAtts;
        }

        protected void parseFromInternal(String setup) {
            String[] parts = setup.split("@@MR@@");
            if (parts.length < 4 || parts.length > 5) {
                throw new IllegalArgumentException("Malformed match definition: " + setup);
            }
            this.m_attsToApplyTo = parts[0].trim();
            this.m_regex = parts[1].trim().toLowerCase().equals("t");
            this.m_ignoreCase = parts[2].trim().toLowerCase().equals("t");
            this.m_match = parts[3].trim();
            if (this.m_match == null || this.m_match.length() == 0) {
                throw new IllegalArgumentException("Must provide something to match!");
            }
            if (parts.length == 5) {
                this.m_label = parts[4].trim();
            }
        }

        public void setMatch(String match) {
            this.m_match = match;
        }

        public String getMatch() {
            return this.m_match;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setRegex(boolean regex) {
            this.m_regex = regex;
        }

        public boolean getRegex() {
            return this.m_regex;
        }

        public void setIgnoreCase(boolean ignore) {
            this.m_ignoreCase = ignore;
        }

        public boolean getIgnoreCase() {
            return this.m_ignoreCase;
        }

        public void setAttsToApplyTo(String a) {
            this.m_attsToApplyTo = a;
        }

        public String getAttsToApplyTo() {
            return this.m_attsToApplyTo;
        }

        public void init(Environment env, Instances structure) {
            HashSet<Integer> indexes;
            this.m_matchS = this.m_match;
            this.m_labelS = this.m_label;
            String attsToApplyToS = this.m_attsToApplyTo;
            try {
                this.m_matchS = env.substitute(this.m_matchS);
                this.m_labelS = env.substitute(this.m_labelS);
                attsToApplyToS = env.substitute(attsToApplyToS);
            }
            catch (Exception ex) {
                // empty catch block
            }
            String tempRangeS = attsToApplyToS;
            tempRangeS = tempRangeS.replace("/first", "first").replace("/last", "last");
            Range tempR = new Range();
            tempR.setRanges(attsToApplyToS);
            try {
                tempR.setUpper(structure.numAttributes() - 1);
                this.m_selectedAtts = tempR.getSelection();
            }
            catch (IllegalArgumentException ex) {
                this.m_selectedAtts = null;
            }
            if (this.m_selectedAtts == null) {
                String[] attParts;
                indexes = new HashSet<Integer>();
                for (String att : attParts = this.m_attsToApplyTo.split(",")) {
                    if ((att = att.trim()).toLowerCase().equals("/first")) {
                        indexes.add(0);
                        continue;
                    }
                    if (att.toLowerCase().equals("/last")) {
                        indexes.add(structure.numAttributes() - 1);
                        continue;
                    }
                    if (structure.attribute(att) != null) {
                        indexes.add(new Integer(structure.attribute(att).index()));
                        continue;
                    }
                    if (this.m_logger == null) continue;
                    String msg = this.m_statusMessagePrefix + "Can't find attribute '" + att + "in the incoming instances - ignoring";
                    this.m_logger.logMessage(msg);
                }
                this.m_selectedAtts = new int[indexes.size()];
                int c = 0;
                for (Integer i : indexes) {
                    this.m_selectedAtts[c++] = i;
                }
            }
            indexes = new HashSet();
            for (int i = 0; i < this.m_selectedAtts.length; ++i) {
                if (structure.attribute(this.m_selectedAtts[i]).isString()) {
                    indexes.add(this.m_selectedAtts[i]);
                    continue;
                }
                if (this.m_logger == null) continue;
                String msg = this.m_statusMessagePrefix + "Attribute '" + structure.attribute(this.m_selectedAtts[i]).name() + "is not a string attribute - " + "ignoring";
                this.m_logger.logMessage(msg);
            }
            this.m_selectedAtts = new int[indexes.size()];
            int c = 0;
            for (Integer i : indexes) {
                this.m_selectedAtts[c++] = i;
            }
        }

        public String apply(Instance inst) {
            for (int i = 0; i < this.m_selectedAtts.length; ++i) {
                String value = inst.stringValue(this.m_selectedAtts[i]);
                String result = this.apply(value);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        protected String apply(String source) {
            String result = source;
            String match = this.m_matchS;
            boolean ruleMatches = false;
            if (this.m_ignoreCase) {
                result = result.toLowerCase();
                match = match.toLowerCase();
            }
            if (result != null && result.length() > 0) {
                if (this.m_regex) {
                    if (result.matches(match)) {
                        ruleMatches = true;
                    }
                } else {
                    ruleMatches = result.indexOf(match) >= 0;
                }
            }
            return ruleMatches ? this.m_label : null;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_regex ? "Regex: " : "Substring: ");
            buff.append(this.m_match).append("  ");
            buff.append(this.m_ignoreCase ? "[ignore case]" : "").append("  ");
            if (this.m_label != null && this.m_label.length() > 0) {
                buff.append("Label: ").append(this.m_label).append("  ");
            }
            buff.append("[Atts: " + this.m_attsToApplyTo + "]");
            return buff.toString();
        }

        protected String toStringInternal() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_attsToApplyTo).append("@@MR@@");
            buff.append(this.m_regex ? "t" : "f").append("@@MR@@");
            buff.append(this.m_ignoreCase ? "t" : "f").append("@@MR@@");
            buff.append(this.m_match).append("@@MR@@");
            buff.append(this.m_label);
            return buff.toString();
        }
    }
}

