/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.io.File;
import javax.swing.text.Document;
import weka.core.Utils;
import weka.core.scripting.Jython;
import weka.gui.ExtensionFileFilter;
import weka.gui.scripting.Script;

public class JythonScript
extends Script {
    private static final long serialVersionUID = 3469648507172973169L;

    public JythonScript() {
    }

    public JythonScript(Document doc) {
        super(doc);
    }

    public JythonScript(Document doc, File file) {
        super(doc, file);
    }

    @Override
    public ExtensionFileFilter[] getFilters() {
        ExtensionFileFilter[] result = new ExtensionFileFilter[]{new ExtensionFileFilter(this.getDefaultExtension(), "Jython script (*" + this.getDefaultExtension() + ")")};
        return result;
    }

    @Override
    public String getDefaultExtension() {
        return ".py";
    }

    @Override
    protected boolean canExecuteScripts() {
        return Jython.isPresent();
    }

    @Override
    protected void preCheck(String[] args) throws Exception {
        super.preCheck(args);
        if (!Jython.isPresent()) {
            throw new Exception("Jython classes are not present in CLASSPATH!");
        }
    }

    @Override
    public Script.ScriptThread newThread(String[] args) {
        return new JythonThread(this, args);
    }

    public static void main(String[] args) throws Exception {
        JythonScript.runScript(new JythonScript(), args);
    }

    public static class JythonThread
    extends Script.ScriptThread {
        public JythonThread(Script owner, String[] args) {
            super(owner, args);
        }

        @Override
        protected void doRun() {
            Class[] classes = new Class[]{String.class};
            Object[] params = new Object[]{this.m_Owner.getFilename().getPath()};
            String argv = "sys.argv = ['" + Utils.backQuoteChars(this.m_Owner.getFilename().getPath()) + "'";
            for (int i = 0; i < this.getArgs().length; ++i) {
                String arg = Utils.backQuoteChars(this.getArgs()[i]);
                argv = argv + ", '" + arg + "'";
            }
            argv = argv + "]";
            Jython jython = new Jython();
            jython.invoke("exec", new Class[]{String.class}, new Object[]{"import sys"});
            jython.invoke("exec", new Class[]{String.class}, new Object[]{argv});
            jython.invoke("execfile", classes, params);
        }
    }
}

