/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.conf.Configuration;
import twitter4j.http.Authorization;
import twitter4j.http.BasicAuthorization;
import twitter4j.http.NullAuthorization;
import twitter4j.http.OAuthAuthorization;

abstract class TwitterBase
implements Serializable {
    protected final Configuration conf;
    protected Authorization auth;
    private static final long serialVersionUID = -3812176145960812140L;

    TwitterBase(Configuration conf) {
        this.conf = conf;
        this.initBasicAuthorization(conf.getUser(), conf.getPassword());
    }

    TwitterBase(Configuration conf, String userId, String password) {
        this.conf = conf;
        this.initBasicAuthorization(userId, password);
    }

    private void initBasicAuthorization(String screenName, String password) {
        if (null != screenName && null != password) {
            this.auth = new BasicAuthorization(screenName, password);
        }
        if (null == this.auth) {
            this.auth = NullAuthorization.getInstance();
        }
    }

    TwitterBase(Configuration conf, Authorization auth) {
        this.conf = conf;
        this.auth = auth;
    }

    public final boolean isBasicAuthEnabled() {
        return this.auth instanceof BasicAuthorization && this.auth.isEnabled();
    }

    protected final void ensureAuthorizationEnabled() {
        if (!this.auth.isEnabled()) {
            throw new IllegalStateException("Authentication credentials are missing. See http://twitter4j.org/configuration.html for the detail.");
        }
    }

    protected final void ensureOAuthEnabled() {
        if (!(this.auth instanceof OAuthAuthorization)) {
            throw new IllegalStateException("OAuth required. Authentication credentials are missing. See http://twitter4j.org/configuration.html for the detail.");
        }
    }

    public final Authorization getAuthorization() {
        return this.auth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TwitterBase)) {
            return false;
        }
        TwitterBase that = (TwitterBase)o;
        return this.auth.equals(that.auth);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public int hashCode() {
        return this.auth != null ? this.auth.hashCode() : 0;
    }

    public String toString() {
        return "TwitterBase{auth=" + this.auth + '}';
    }
}

