/**
 * ZipArchiveHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.tools.previewbrowser;

import java.io.File;
import java.util.Vector;

import adams.core.Utils;

import adams.core.io.ZipUtils;

/**
 <!-- globalinfo-start -->
 * Offers access to ZIP files. Handles the following extensions: zip,jar
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D &lt;int&gt; (property: debugLevel)
 * &nbsp;&nbsp;&nbsp;The greater the number the more additional info the scheme may output to
 * &nbsp;&nbsp;&nbsp;the console (0 = off).
 * &nbsp;&nbsp;&nbsp;default: 0
 * &nbsp;&nbsp;&nbsp;minimum: 0
 * </pre>
 *
 * <pre>-archive &lt;adams.core.io.PlaceholderFile&gt; (property: archive)
 * &nbsp;&nbsp;&nbsp;The archive to obtain the files from.
 * &nbsp;&nbsp;&nbsp;default: .
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3761 $
 */
public class ZipArchiveHandler
  extends AbstractArchiveHandler {

  /** for serialization. */
  private static final long serialVersionUID = 1421258971073361083L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "Offers access to ZIP files. Handles the following extensions: "
      + Utils.arrayToString(getExtensions());
  }

  /**
   * Returns the list of extensions (without dot) that this handler can
   * take care of.
   *
   * @return		the list of extensions (no dot)
   */
  public String[] getExtensions() {
    return new String[]{"zip", "jar"};
  }

  /**
   * Performs actual listing of files.
   *
   * @return		the stored files
   */
  protected String[] listFiles() {
    String[]		result;
    Vector<File>	files;
    int			i;

    files  = ZipUtils.listFiles(m_Archive, false);
    result = new String[files.size()];
    for (i = 0; i < result.length; i++)
      result[i] = files.get(i).getPath();

    return result;
  }

  /**
   * Extracts the specified file and saves it locally.
   *
   * @param archiveFile	the file in the archive to extract
   * @param outFile	the local file to store the content in
   * @return		true if successfully extracted
   */
  protected boolean doExtract(String archiveFile, File outFile) {
    return ZipUtils.decompress(m_Archive, archiveFile, outFile);
  }
}
