/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.LzmaUtils;
import adams.flow.transformer.AbstractSingleCompress;
import java.io.File;

public class Lzma
extends AbstractSingleCompress {
    private static final long serialVersionUID = -4692431747542097656L;

    public String globalInfo() {
        return "Creates a LZMA (7zip) archive from a single file. Outputs the filename of the LZMA file generated. Optionally, the original input file can be deleted.";
    }

    @Override
    public String outputTipText() {
        return "The LZMA (7zip) file to create; if pointing to a directory, then the output filename is based on the file that is being compressed and the '.7z' extension added.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".7z";
    }

    @Override
    protected String compress(File inFile, File outFile) {
        return LzmaUtils.compress(inFile, this.m_BufferSize, outFile, this.m_RemoveInputFile);
    }
}

