/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.flow.transformer.ArrayToSequence;
import adams.flow.transformer.Bzip2;
import adams.flow.transformer.TextFileReader;
import adams.flow.transformer.UnBzip2;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class UnBzip2Test
extends AbstractFlowTest {
    public UnBzip2Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow.bz2");
        this.m_TestHelper.deleteFileFromTmp("external_singleton2.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.flow");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow");
        this.m_TestHelper.deleteFileFromTmp("external_standalone.flow.bz2");
        this.m_TestHelper.deleteFileFromTmp("external_singleton2.flow");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.flow");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants sc = new StringConstants();
        sc.setStrings(new BaseString[]{new BaseString("${TMP}/external_standalone.flow")});
        Bzip2 zip = new Bzip2();
        UnBzip2 unzip = new UnBzip2();
        unzip.setAlternativeFilename("external_singleton2.flow");
        TextFileReader tfr = new TextFileReader();
        ArrayToSequence a2s = new ArrayToSequence();
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.flow"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sc, zip, unzip, tfr, a2s, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.flow"));
    }

    public static Test suite() {
        return new TestSuite(UnBzip2Test.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        UnBzip2Test.runTest((Test)UnBzip2Test.suite());
    }
}

