/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.GzipUtils;
import adams.flow.transformer.AbstractSingleCompress;
import java.io.File;

public class GZIP
extends AbstractSingleCompress {
    private static final long serialVersionUID = 6718580828800815681L;

    public String globalInfo() {
        return "Creates a GZIP archive from a single file. Outputs the filename of the GZIP file generated. Optionally, the original input file can be deleted.";
    }

    @Override
    public String outputTipText() {
        return "The GZIP file to create; if pointing to a directory, then the output filename is based on the file that is being compressed and the '.gz' extension added.";
    }

    @Override
    protected String getDefaultExtension() {
        return ".gz";
    }

    @Override
    protected String compress(File inFile, File outFile) {
        return GzipUtils.compress(inFile, this.m_BufferSize, outFile, this.m_RemoveInputFile);
    }
}

