/*
 * Mergeable.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

/**
 * For objects that allow merging.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 * @param <T> The class type.
 */
public interface Mergeable<T> {

  /**
   * Merges its own data with the one provided by the specified object.
   * 
   * @param other		the object to merge with
   */
  public void mergeWith(T other);
}
