/**
 * Pausable.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core;

/**
 * Interface for objects that can be paused and resumed.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 475 $
 */
public interface Pausable {

  /**
   * Pauses the execution.
   */
  public void pauseExecution();

  /**
   * Returns whether the object is currently paused.
   *
   * @return		true if object is paused
   */
  public boolean isPaused();

  /**
   * Resumes the execution.
   */
  public void resumeExecution();
}
