/*
 * BaseString.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.core.base;

/**
 * Wrapper for a String object to be editable in the GOE.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3276 $
 */
public class BaseString
  extends BaseObject {

  /** for serialization. */
  private static final long serialVersionUID = -5853830144343397434L;

  /**
   * Initializes the string with length 0.
   */
  public BaseString() {
    this("");
  }

  /**
   * Initializes the object with the string to parse.
   *
   * @param s		the string to parse
   */
  public BaseString(String s) {
    super(s);
  }

  /**
   * Checks whether the string value is a valid presentation for this class.
   *
   * @param value	the string value to check
   * @return		always true
   */
  public boolean isValid(String value) {
    return true;
  }

  /**
   * Converts the string according to the specified conversion.
   * <p/>
   * Default implementation performs no conversion.
   *
   * @param value	the string to convert
   * @return		the converted string
   */
  protected String convert(String value) {
    return value;
  }

  /**
   * Sets the string value.
   * <p/>
   * Calls <code>convert(String)</code> first before checking validity or
   * setting the value (if valid).
   *
   * @param value	the string value
   */
  public void setValue(String value) {
    if (!isValid(value))
      return;

    m_Internal = convert(value);
  }

  /**
   * Returns the current string value.
   *
   * @return		the string value
   */
  public String getValue() {
    return (String) m_Internal;
  }

  /**
   * Returns the String value.
   *
   * @return		the String value
   */
  public String stringValue() {
    return getValue();
  }

  /**
   * Whether the string is empty, i.e., "".
   *
   * @return		true if the string is empty, i.e., length 0
   */
  public boolean isEmpty() {
    return (((String) m_Internal).length() == 0);
  }

  /**
   * Returns a tool tip for the GUI editor (ignored if null is returned).
   *
   * @return		the tool tip
   */
  public String getTipText() {
    return "An arbitrary string.";
  }
}
