/**
 * AbstractTextWriter.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.core.io;

import adams.core.option.OptionHandlingObject;

/**
 * Ancestor for classes that can write text documents.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 1300 $
 */
public abstract class AbstractTextWriter
  extends OptionHandlingObject {

  /** for serialization. */
  private static final long serialVersionUID = -432793583505607999L;

  /**
   * Writes the given content under the specified name.
   *
   * @param content	the content to write
   * @param name	the name under which to save the content
   * @return		if a file was generated, the filename the content was written
   * 			as, otherwise null
   */
  public abstract String write(String content, String name);
}
