/**
 * OptionTraverserWithResult.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

/**
 * Interface for traversers that return a result.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3969 $
 * @param <T> the type of result to generate
 */
public interface OptionTraverserWithResult<T>
  extends OptionTraverser {

  /**
   * Returns the result of the traversal.
   *
   * @return		the result
   */
  public T getResult();
}
