/*
 * Polynomial.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.data.fit;

import adams.core.Utils;

/**
 <!-- globalinfo-start -->
 * Polynomial function of the form:<br/>
 * f(x) = a0 + a1*x + a2*x^2 + ... + aN*x^N
 * <p/>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <p/>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2537 $
 */
public class Polynomial
  extends LinearFunction {

  /** for serialization. */
  private static final long serialVersionUID = 8671881135961725212L;

  /**
   * Returns a short description of the function.
   *
   * @return		a description of the function
   */
  public String globalInfo() {
    return
        "Polynomial function of the form:\n"
      + "f(x) = a0 + a1*x + a2*x^2 + ... + aN*x^N";
  }

  /**
   * Calculates the function values, based on the x value.
   *
   * @param x		the x value
   * @param num		the number of basis functions
   * @return		the function values, gets updated
   */
  public double[] calcFunctionValues(double x, int num) {
    double[]	result;
    int		i;

    result    = new double[num];
    result[0] = 1.0;
    for (i = 1; i < num; i++)
      result[i] = result[i - 1] * x;

    getDebugging().println("x=" + x + " -> " + Utils.arrayToString(result));

    return result;
  }

  /**
   * Calculates the y value, based on the x value and coefficients.
   *
   * @param x		the x value
   * @param a		the coefficients
   * @return		the y value
   */
  public double calcY(double x, double[] a) {
    double	result;
    int		i;

    result = 0.0;
    for (i = 0; i < a.length; i++)
      result += a[i] * Math.pow(x, i);

    getDebugging().println("x=" + x + " -> y=" + result);

    return result;
  }
}
