/**
 * IncrementalDataContainerReader.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.data.io.input;

/**
 * For data container readers that can read the data incrementally.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 445 $
 */
public interface IncrementalDataContainerReader {

  /**
   * Returns whether there is more data available.
   *
   * @return		true if there is more data available
   */
  public boolean hasMoreData();
}
