/**
 * AbstractReconnectableDatabaseConnection.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import adams.core.base.BasePassword;

/**
 * Ancestor for database connection classes that offer reconnecting to
 * another URL.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public abstract class AbstractReconnectableDatabaseConnection
  extends AbstractDatabaseConnection
  implements ReconnectableDatabaseConnection {

  /** for serialization. */
  private static final long serialVersionUID = -5575792002262680914L;

  /**
   * Constructor, uses the default settings.
   */
  protected AbstractReconnectableDatabaseConnection() {
    super();
  }

  /**
   * Reconnects with the given parameters if they differ from the current
   * settings.
   *
   * @param url		the JDBC URL
   * @param user	the database user
   * @param password	the database password
   * @return		true if the reconnect was successful (or not necessary)
   */
  public synchronized boolean reconnect(String url, String user, BasePassword password) {
    boolean	result;

    result = true;

    // do we have to reconnect?
    if (    !url.equals(getURL())
	 || !user.equals(getUser())
	 || !password.equals(getPassword())) {

      if (isConnected())
	disconnect();

      setURL(url);
      setUser(user);
      setPassword(password);

      try {
	result = connect();
      }
      catch (Exception e) {
	result = false;
	getSystemErr().printStackTrace(e);
      }
    }
    else {
      if (!isConnected()) {
	try {
	  result = connect();
	}
	catch (Exception e) {
	  result = false;
	  getSystemErr().printStackTrace(e);
	}
      }
    }

    return result;
  }
}
