/*
 * Indices.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.db.indices;

import java.util.Vector;

/**
 * Indices is a collection of Index objects for a table
 * 
 * @author dale
 * @version $Revision: 1185 $
 */
public class Indices extends Vector<Index>{

  private static final long serialVersionUID = -6266605625222865131L;

  /**
   * Constructor
   *
   */
  public Indices() {
    super();
  }

  /**
   * Does the given Indices object match this?
   * @param ind
   * @return equals?
   */
  public boolean equals(Indices ind) {
    if (ind.size() != size()) {
      return(false); 
    }
    for (int i=0;i<ind.size();i++) {
      if (!present(ind.get(i))) {
	return(false);
      }
    }
    return(true);
  }
  
  /**
   * Is the Index present in this Indices object?
   * @param incol	Index
   * @return	present?
   */
  public boolean present(Index incol) {    
    for (int i=0;i<size();i++) {
      Index ic=get(i);
      if (ic.equals(incol)) {
	return(true);
      }     
    }
    return(false);
  }
}
