/**
 * SpreadSheetCellRenderer.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.core;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

import adams.core.io.SpreadSheet.Cell;

/**
 * Custom cell renderer for displaying spreadsheets.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2314 $
 */
public class SpreadSheetCellRenderer
  extends DefaultTableCellRenderer {

  /** for serialization. */
  private static final long serialVersionUID = -6070112998601610760L;

  /**
   * Returns the default table cell renderer.
   *
   * @param table		the table this object belongs to
   * @param value		the actual cell value
   * @param isSelected		whether the cell is selected
   * @param hasFocus		whether the cell has the focus
   * @param row			the row in the table
   * @param column		the column in the table
   * @return			the rendering component
   */
  public Component getTableCellRendererComponent(
      JTable table, Object value, boolean isSelected,
      boolean hasFocus, int row, int column ) {

    Component 	result;
    Cell		cell;

    result = super.getTableCellRendererComponent(
        	table, value, isSelected, hasFocus, row, column);
    cell   = ((SpreadSheetTable) table).getCellAt(row, column);

    if (cell != null) {
      // background and hint
      if (cell.isMissing()) {
        ((JLabel) result).setToolTipText("missing");
        if (isSelected)
          ((JLabel) result).setBackground(Color.GRAY);
        else
          ((JLabel) result).setBackground(Color.LIGHT_GRAY);
      }
      else {
        ((JLabel) result).setToolTipText(null);
        if (isSelected)
          ((JLabel) result).setBackground(table.getSelectionBackground());
        else
          ((JLabel) result).setBackground(table.getBackground());
      }

      // alignment
      if (cell.isNumeric())
        ((JLabel) result).setHorizontalAlignment(SwingConstants.RIGHT);
      else
        ((JLabel) result).setHorizontalAlignment(SwingConstants.LEFT);
    }
    else {
      ((JLabel) result).setToolTipText("missing");
      if (isSelected)
        ((JLabel) result).setBackground(Color.GRAY);
      else
        ((JLabel) result).setBackground(Color.LIGHT_GRAY);
    }

    return result;
  }
}