/**
 * ActorParametersTab.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.flow.tab;

import java.awt.BorderLayout;
import java.awt.Font;

import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.tree.TreePath;

import adams.core.option.HtmlParametersProducer;
import adams.flow.core.AbstractActor;
import adams.gui.core.BaseScrollPane;

/**
 * Tab for displaying the parameters for the currently selected actor.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4083 $
 */
public class ActorParametersTab
  extends AbstractEditorTab
  implements SelectionAwareEditorTab {

  /** for serialization. */
  private static final long serialVersionUID = 3860012648562358118L;

  /** the default text if no actor has been selected. */
  public final static String DEFAULT_TEXT = "<html><center><b>No actor selected</b></center></html>";

  /** for displaying the help text. */
  protected JEditorPane m_TextArea;

  /**
   * Initializes the widgets.
   */
  protected void initGUI() {
    super.initGUI();

    setLayout(new BorderLayout());

    m_TextArea = new JEditorPane();
    m_TextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    m_TextArea.setEditable(false);
    m_TextArea.setFont(new Font("monospaced", Font.PLAIN, 12));
    m_TextArea.setAutoscrolls(true);
    m_TextArea.setContentType("text/html");
    m_TextArea.setText(DEFAULT_TEXT);

    add(new BaseScrollPane(m_TextArea), BorderLayout.CENTER);
  }

  /**
   * Returns the title of the tab.
   *
   * @return		the title
   */
  public String getTitle() {
    return "Parameters";
  }

  /**
   * Notifies the tab of the currently selected actors.
   *
   *
   * @param paths	the selected paths
   * @param actors	the currently selected actors
   */
  public void actorSelectionChanged(TreePath[] paths, AbstractActor[] actors) {
    HtmlParametersProducer 	producer;

    if (actors.length != 1) {
      m_TextArea.setText(DEFAULT_TEXT);
      return;
    }

    producer = new HtmlParametersProducer();
    producer.produce(actors[0]);

    m_TextArea.setText(producer.toString());
    m_TextArea.setCaretPosition(0);
  }
}
