/*
 *    CustomPanelSupplier.java
 *    Copyright (C) 2002 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.goe;

import javax.swing.JPanel;

/**
 * An interface for objects that are capable of supplying their own
 * custom GUI components. The original purpose for this interface is
 * to provide a mechanism allowing the GenericObjectEditor to override
 * the standard PropertyPanel GUI.
 *
 * @author Richard Kirkby (rkirkby@cs.waikato.ac.nz)
 * @version $Revision: 4 $
 */
public interface CustomPanelSupplier {

  /**
   * Gets the custom panel for the object.
   *
   * @return 		the custom JPanel
   */
  public JPanel getCustomPanel();
}
