/*
 * GlobalActorsNode.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.goe.globalactorstree;

import adams.flow.standalone.GlobalActors;
import adams.gui.core.dotnotationtree.DotNotationNode;

/**
 * Specialized tree node.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3584 $
 */
public class GlobalActorsNode
  extends DotNotationNode {

  /** for serialization. */
  private static final long serialVersionUID = 9062259637831548370L;

  /** the classname of the actor. */
  protected String m_Classname;

  /**
   * Initializes the class node with the specified label (package or class
   * name).
   *
   * @param label	the label for this node
   */
  public GlobalActorsNode(String label) {
    super(label);
  }

  /**
   * Sets the classname of the actor.
   *
   * @param value	the classname
   */
  public void setClassname(String value) {
    m_Classname = value;
  }

  /**
   * Returns the class name of the actor.
   *
   * @return		the actor's class name
   */
  public String getClassname() {
    return m_Classname;
  }

  /**
   * Returns whether this node represents a global actor.
   *
   * @return		true if a global actor
   */
  public boolean isGlobalActor() {
    return ((m_Classname != null) && !m_Classname.equals(GlobalActors.class.getName()));
  }
}