/*
 * About.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 *
 */

package adams.gui.menu;

import adams.gui.application.AbstractApplicationFrame;
import adams.gui.application.AbstractMenuItemDefinition;
import adams.gui.application.ChildFrame;
import adams.gui.application.UserMode;
import adams.gui.core.AboutBoxPanel;

/**
 * Displays the infamous about box.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2797 $
 */
public class About
  extends AbstractMenuItemDefinition {

  /** for serialization. */
  private static final long serialVersionUID = -771667287275117680L;

  /**
   * Initializes the menu item.
   *
   * @param owner	the owning application
   */
  public About(AbstractApplicationFrame owner) {
    super(owner);
  }

  /**
   * Returns the file name of the icon.
   *
   * @return		the filename or null if no icon available
   */
  public String getIconName() {
    return "help.gif";
  }

  /**
   * Launches the functionality of the menu item.
   */
  public void launch() {
    AboutBoxPanel panel = new AboutBoxPanel();
    panel.addInfo("<html><font color='red'>A</font>dvanced <font color='red'>D</font>ata mining and <font color='red'>M</font>achine learning <font color='red'>S</font>ystem</html>");
    panel.addInfo("(c) 2009-2011 University of Waikato");
    panel.addInfo("Hamilton, New Zealand");
    ChildFrame frame = createChildFrame(panel);
    frame.setResizable(false);
    frame.pack();
  }

  /**
   * Returns the title of the window (and text of menuitem).
   *
   * @return 		the title
   */
  public String getTitle() {
    return "About";
  }

  /**
   * Whether the panel can only be displayed once.
   *
   * @return		true if the panel can only be displayed once
   */
  public boolean isSingleton() {
    return true;
  }

  /**
   * Returns the user mode, which determines visibility as well.
   *
   * @return		the user mode
   */
  public UserMode getUserMode() {
    return UserMode.BASIC;
  }

  /**
   * Returns the category of the menu item in which it should appear, i.e.,
   * the name of the menu.
   *
   * @return		the category/menu name
   */
  public String getCategory() {
    return CATEGORY_HELP;
  }
}