/**
 * SendToActionSupporter.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.sendto;

/**
 * Interface for panels/etc that support SendTo actions.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3890 $
 */
public interface SendToActionSupporter {

  /**
   * Returns the classes that the supporter generates.
   *
   * @return		the classes
   */
  public Class[] getSendToClasses();

  /**
   * Checks whether something to send is available.
   *
   * @param cls		the classes to retrieve an item for
   * @return		true if an object is available for sending
   */
  public boolean hasSendToItem(Class[] cls);

  /**
   * Returns the object to send.
   *
   * @param cls		the classes to retrieve an item for
   * @return		the item to send, null if nothing available at the
   * 			moment
   */
  public Object getSendToItem(Class[] cls);
}
