/*
 * ContainerListPopupMenuSupplier.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */

package adams.gui.visualization.container;

import javax.swing.JPopupMenu;

/**
 * Interface for components that can supply a popup menu for the
 * container list.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 952 $
 * @param <M> the type of container manager to use
 * @param <C> the type of container to use
 */
public interface ContainerListPopupMenuSupplier<M extends ContainerManager, C extends Container> {

  /**
   * Returns a popup menu for the table of the container list.
   *
   * @param table	the affected table
   * @param row	the row the mouse is currently over
   * @return		the popup menu
   */
  public JPopupMenu getContainerListPopupMenu(ContainerTable<M,C> table, int row);
}