/**
 * AbstractInspectionHandler.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.debug.inspectionhandler;

import java.util.Hashtable;

import adams.core.ClassLister;

/**
 * Ancestor for handlers that provide further insight into certain types of
 * objects.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3101 $
 */
public abstract class AbstractInspectionHandler {

  /**
   * Checks whether the handler can handle the specified object.
   *
   * @param obj		the object to check
   * @return		true if the handler can handle this type of object
   */
  public abstract boolean handles(Object obj);

  /**
   * Returns further inspection values.
   *
   * @param obj		the object to further inspect
   * @return		the named inspected values
   */
  public abstract Hashtable<String,Object> inspect(Object obj);

  /**
   * Returns a list with classnames of handlers.
   *
   * @return		the handler classnames
   */
  public static String[] getHandlers() {
    return ClassLister.getSingleton().getClassnames(AbstractInspectionHandler.class);
  }
}
