/**
 * ArrayProducerConsumerTest.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.option.ArrayConsumer;
import adams.core.option.ArrayProducer;

/**
 * Tests the ArrayProducer/Consumer classes.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class ArrayProducerConsumerTest
  extends AbstractOptionProducerConsumerTestCase {

  /**
   * Initializes the test.
   *
   * @param name	the name of the test
   */
  public ArrayProducerConsumerTest(String name) {
    super(name);
  }

  /**
   * Returns a default producer.
   *
   * @return		the producer
   */
  protected AbstractOptionProducer getProducer() {
    return new ArrayProducer();
  }

  /**
   * Returns a default consumer.
   *
   * @return		the consumer
   */
  protected AbstractOptionConsumer getConsumer() {
    return new ArrayConsumer();
  }
}
