/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.Index;
import adams.env.Environment;
import adams.test.AdamsTestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

public class IndexTest
extends AdamsTestCase {
    public IndexTest(String name) {
        super(name);
    }

    public void testHasIndex() {
        Index index = new Index();
        IndexTest.assertFalse((boolean)index.hasIndex());
        index = new Index("");
        IndexTest.assertFalse((boolean)index.hasIndex());
        index = new Index("1");
        IndexTest.assertTrue((boolean)index.hasIndex());
        index = new Index("1", 10);
        IndexTest.assertTrue((boolean)index.hasIndex());
        index = new Index("100", 10);
        IndexTest.assertTrue((boolean)index.hasIndex());
    }

    public void testFirst() {
        Index index = new Index("first", 10);
        IndexTest.assertEquals((int)0, (int)index.getIntIndex());
    }

    public void testSecond() {
        Index index = new Index("second", 10);
        IndexTest.assertEquals((int)1, (int)index.getIntIndex());
    }

    public void testThird() {
        Index index = new Index("third", 10);
        IndexTest.assertEquals((int)2, (int)index.getIntIndex());
    }

    public void testFirstMixed() {
        Index index = new Index("First", 10);
        IndexTest.assertEquals((int)0, (int)index.getIntIndex());
    }

    public void testSecondMixed() {
        Index index = new Index("Second", 10);
        IndexTest.assertEquals((int)1, (int)index.getIntIndex());
    }

    public void testThirdMixed() {
        Index index = new Index("Third", 10);
        IndexTest.assertEquals((int)2, (int)index.getIntIndex());
    }

    public void testLastMinus2() {
        Index index = new Index("last_2", 10);
        IndexTest.assertEquals((int)(index.getMax() - 3), (int)index.getIntIndex());
    }

    public void testLastMinus1() {
        Index index = new Index("last_1", 10);
        IndexTest.assertEquals((int)(index.getMax() - 2), (int)index.getIntIndex());
    }

    public void testLast() {
        Index index = new Index("last", 10);
        IndexTest.assertEquals((int)(index.getMax() - 1), (int)index.getIntIndex());
    }

    public void testLastMinus2Mixed() {
        Index index = new Index("Last_2", 10);
        IndexTest.assertEquals((int)(index.getMax() - 3), (int)index.getIntIndex());
    }

    public void testLastMinus1Mixed() {
        Index index = new Index("Last_1", 10);
        IndexTest.assertEquals((int)(index.getMax() - 2), (int)index.getIntIndex());
    }

    public void testLastMixed() {
        Index index = new Index("Last", 10);
        IndexTest.assertEquals((int)(index.getMax() - 1), (int)index.getIntIndex());
    }

    public void testNumber() {
        Index index = new Index("3", 10);
        IndexTest.assertEquals((int)2, (int)index.getIntIndex());
    }

    public void testInvalidIndex() {
        Index index = new Index("blah", 10);
        IndexTest.assertEquals((int)-1, (int)index.getIntIndex());
    }

    public void testNoMax() {
        Index index = new Index("first");
        IndexTest.assertEquals((int)-1, (int)index.getIntIndex());
    }

    public static Test suite() {
        return new TestSuite(IndexTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        IndexTest.runTest(IndexTest.suite());
    }
}

