/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseObjectTestCase;
import adams.core.base.BaseURI;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseURITest
extends AbstractBaseObjectTestCase<BaseURI> {
    public BaseURITest(String name) {
        super(name);
    }

    @Override
    protected BaseURI getDefault() {
        return new BaseURI();
    }

    @Override
    protected BaseURI getCustom(String s) {
        return new BaseURI(s);
    }

    @Override
    protected String getTypicalValue() {
        return "http://www.waikato.ac.nz/";
    }

    public static Test suite() {
        return new TestSuite(BaseURITest.class);
    }

    public void testPort() {
        String value = "https://www.waikato.ac.nz:443/";
        try {
            BaseURI b = this.getCustom(value);
            BaseURITest.assertEquals((String)"values differ", (String)value, (String)b.getValue());
        }
        catch (Exception e) {
            BaseURITest.fail((String)("Parsing failed: " + e));
        }
    }

    public void testJDBC() {
        String value = "jdbc:mysql://localhost:3306/adams";
        try {
            BaseURI b = this.getCustom(value);
            BaseURITest.assertEquals((String)"values differ", (String)value, (String)b.getValue());
        }
        catch (Exception e) {
            BaseURITest.fail((String)("Parsing failed: " + e));
        }
    }

    public void testMailto() {
        String value = "mailto:help@nowhere.com";
        try {
            BaseURI b = this.getCustom(value);
            BaseURITest.assertEquals((String)"values differ", (String)value, (String)b.getValue());
        }
        catch (Exception e) {
            BaseURITest.fail((String)("Parsing failed: " + e));
        }
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseURITest.runTest(BaseURITest.suite());
    }
}

