/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractNumericOptionTest;
import adams.core.option.AbstractOptionTest;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class FloatOptionTest
extends AbstractNumericOptionTest {
    public FloatOptionTest(String name) {
        super(name);
    }

    protected OptionHandler getOptionHandler() {
        return new FloatOptionClass();
    }

    protected String getLowerBoundTestProperty() {
        return "floatObj";
    }

    protected Float getLowerBoundTestValue() {
        return new Float(-100.0f);
    }

    protected String getUpperBoundTestProperty() {
        return "floatObj";
    }

    protected Float getUpperBoundTestValue() {
        return new Float(100.0f);
    }

    public static Test suite() {
        return new TestSuite(FloatOptionTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        FloatOptionTest.runTest(FloatOptionTest.suite());
    }

    public static class FloatOptionClass
    extends AbstractOptionTest.AbstractOptionClass {
        private static final long serialVersionUID = 4373423899774166393L;
        protected float m_FloatPrim;
        protected float[] m_FloatPrimArray;
        protected Float m_FloatObj;
        protected Float[] m_FloatObjArray;

        public void defineOptions() {
            super.defineOptions();
            this.m_OptionManager.add("float-prim", "floatPrim", (Object)Float.valueOf(1.0f));
            this.m_OptionManager.add("float-prim-array", "floatPrimArray", (Object)new float[]{1.0f, 2.0f, 3.0f});
            this.m_OptionManager.add("float-obj", "floatObj", (Object)new Float(2.0f), (Number)new Float(-10.0f), (Number)new Float(10.0f));
            this.m_OptionManager.add("float-obj-array", "floatObjArray", (Object)new Float[]{new Float(4.0f), new Float(5.0f), new Float(6.0f)});
        }

        public void setFloatPrim(float value) {
            this.m_FloatPrim = value;
        }

        public float getFloatPrim() {
            return this.m_FloatPrim;
        }

        public String floatPrimTipText() {
            return "floatPrim";
        }

        public void setFloatPrimArray(float[] value) {
            this.m_FloatPrimArray = value;
        }

        public float[] getFloatPrimArray() {
            return this.m_FloatPrimArray;
        }

        public String floatPrimArrayTipText() {
            return "floatPrimArray";
        }

        public void setFloatObj(Float value) {
            this.m_FloatObj = value;
        }

        public Float getFloatObj() {
            return this.m_FloatObj;
        }

        public String floatObjTipText() {
            return "floatObj";
        }

        public void setFloatObjArray(Float[] value) {
            this.m_FloatObjArray = value;
        }

        public Float[] getFloatObjArray() {
            return this.m_FloatObjArray;
        }

        public String floatObjArrayTipText() {
            return "floatObjArray";
        }
    }
}

