/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.data.container.DataContainer;
import adams.data.statistics.AbstractDataStatistic;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataStatisticTestCase<A extends AbstractDataStatistic, D extends DataContainer>
extends AdamsTestCase {
    public AbstractDataStatisticTestCase(String name) {
        super(name);
    }

    @Override
    protected AbstractTestHelper newTestHelper() {
        return new TestHelper(this, "adams/data/statistic/data");
    }

    protected A process(D data, A scheme) {
        scheme.setData(data);
        return scheme;
    }

    protected Vector<String> toString(A scheme) {
        Vector<String> result = new Vector<String>();
        Vector namesSorted = new Vector();
        Enumeration names = scheme.statisticNames();
        while (names.hasMoreElements()) {
            namesSorted.add(names.nextElement());
        }
        Collections.sort(namesSorted);
        for (String name : namesSorted) {
            result.add(name + ": " + scheme.getStatistic(name));
        }
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract A[] getRegressionSetups();

    protected abstract D load(String var1);

    protected boolean save(Vector<String> data, String filename) {
        return FileUtils.saveToFile(data, (File)new File(this.m_TestHelper.getTmpDirectory() + File.separator + filename));
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractDataStatistic[] setups = this.getRegressionSetups();
        AbstractDataStatisticTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            D data = this.load(input[i]);
            AbstractDataStatisticTestCase.assertNotNull((String)("Could not load data for regression test from " + input[i]), data);
            Vector<String> processed = this.toString(this.process(data, setups[i]));
            AbstractDataStatisticTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i]);
            AbstractDataStatisticTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractDataStatisticTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                ((Destroyable)setups[i]).destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
    }

    protected void cleanUpAfterRegression() {
    }
}

