/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ConditionalTee;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.StringConstants;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ConditionalTeeTest
extends AbstractFlowTest {
    public ConditionalTeeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-count1.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-count2.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-count3.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-count1.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-count2.txt");
        this.m_TestHelper.deleteFileFromTmp("dumpfile-count3.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        StringConstants ids = new StringConstants();
        ids.setStrings(new BaseString[]{new BaseString("1"), new BaseString("2"), new BaseString("3"), new BaseString("4"), new BaseString("5"), new BaseString("6"), new BaseString("7"), new BaseString("8"), new BaseString("9"), new BaseString("10"), new BaseString("11"), new BaseString("12"), new BaseString("13"), new BaseString("14"), new BaseString("15"), new BaseString("16"), new BaseString("17"), new BaseString("18"), new BaseString("19"), new BaseString("20"), new BaseString("21"), new BaseString("22"), new BaseString("23"), new BaseString("24"), new BaseString("25"), new BaseString("26"), new BaseString("27"), new BaseString("28"), new BaseString("29"), new BaseString("30")});
        DumpFile df1 = new DumpFile();
        df1.setAppend(true);
        df1.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-count1.txt"));
        ConditionalTee cnt1 = new ConditionalTee();
        cnt1.setInterval(3);
        cnt1.add(0, (AbstractActor)df1);
        DumpFile df2 = new DumpFile();
        df2.setAppend(true);
        df2.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-count2.txt"));
        ConditionalTee cnt2 = new ConditionalTee();
        cnt2.setInterval(3);
        cnt2.setMinimum(10);
        cnt2.add(0, (AbstractActor)df2);
        DumpFile df3 = new DumpFile();
        df3.setAppend(true);
        df3.setOutputFile((PlaceholderFile)new TmpFile("dumpfile-count3.txt"));
        ConditionalTee cnt3 = new ConditionalTee();
        cnt3.setInterval(3);
        cnt3.setMinimum(10);
        cnt3.setMaximum(20);
        cnt3.add(0, (AbstractActor)df3);
        DumpFile df = new DumpFile();
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ids, cnt1, cnt2, cnt3, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest(new File[]{new TmpFile("dumpfile.txt"), new TmpFile("dumpfile-count1.txt"), new TmpFile("dumpfile-count2.txt"), new TmpFile("dumpfile-count3.txt")});
    }

    public static Test suite() {
        return new TestSuite(ConditionalTeeTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ConditionalTeeTest.runTest(ConditionalTeeTest.suite());
    }
}

