/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.data.statistics.ArrayMedian;
import adams.data.statistics.MultiArrayStatistic;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.RandomNumberGenerator;
import adams.flow.transformer.ArrayStatistic;
import adams.flow.transformer.SequenceToArray;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ArrayStatisticTest
extends AbstractFlowTest {
    public ArrayStatisticTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public AbstractActor getActor() {
        RandomNumberGenerator rng = new RandomNumberGenerator();
        rng.setMaxNum(100);
        SequenceToArray s2a1 = new SequenceToArray();
        s2a1.setArrayLength(10);
        SequenceToArray s2a2 = new SequenceToArray();
        s2a2.setArrayLength(10);
        MultiArrayStatistic mas = new MultiArrayStatistic();
        mas.setSubStatistics(new AbstractArrayStatistic[]{new ArrayMedian(), new ArrayMean()});
        ArrayStatistic is = new ArrayStatistic();
        is.setDataType(ArrayStatistic.DataType.COLUMN_BY_INDEX);
        is.setLocations(new BaseString[]{new BaseString("1"), new BaseString("last")});
        is.setStatistic((AbstractArrayStatistic)mas);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.csv"));
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{rng, s2a1, s2a2, is, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)((Object)new TmpFile("dumpfile.csv")));
    }

    public static Test suite() {
        return new TestSuite(ArrayStatisticTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        ArrayStatisticTest.runTest(ArrayStatisticTest.suite());
    }
}

