/*
 * Decompiled with CFR 0.152.
 */
package adams.test;

import adams.core.base.BasePassword;
import adams.core.io.FileUtils;
import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TmpFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHelper<I extends DataContainer, O>
extends AbstractTestHelper<I, O> {
    public TestHelper(AdamsTestCase owner, String dataDir) {
        super(owner, dataDir);
    }

    @Override
    public I load(String filename) {
        return null;
    }

    @Override
    public boolean save(O data, String filename) {
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)data.toString(), (boolean)false);
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection(String url, String user, BasePassword password) {
        this.m_DatabaseConnection = DatabaseConnection.getSingleton((String)url, (String)user, (BasePassword)password);
        return this.m_DatabaseConnection;
    }

    @Override
    public void connect(String url, String user, BasePassword password) {
        this.m_DatabaseConnection = DatabaseConnection.getSingleton((String)url, (String)user, (BasePassword)password);
        String lastError = this.m_DatabaseConnection.getLastConnectionError();
        if (!this.m_DatabaseConnection.isConnected()) {
            try {
                this.m_DatabaseConnection.connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.m_DatabaseConnection.isConnected()) {
            if (this.m_DatabaseConnection.getLastConnectionError().length() > 0) {
                lastError = this.m_DatabaseConnection.getLastConnectionError();
            }
            throw new IllegalStateException("Failed to connect to database:\n" + this.m_DatabaseConnection.toStringShort() + " (" + lastError + ")");
        }
    }
}

