/*
 * TechnicalInformationHandler.java
 * Copyright (C) 2006 University of Waikato, Hamilton, New Zealand
 */

package adams.core;

/**
 * For classes that are based on some kind of publications. They return
 * a TechnicalInformation object filled with the data of the publication.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4 $
 * @see TechnicalInformation
 * @see weka.core.TechnicalInformationHandler
 */
public interface TechnicalInformationHandler {

  /**
   * Returns an instance of a TechnicalInformation object, containing 
   * detailed information about the technical background of this class,
   * e.g., paper reference or book this class is based on.
   * 
   * @return the technical information about this class
   */
  public TechnicalInformation getTechnicalInformation();
}
