/**
 * ThirdPartyCopyright.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.core.annotation;

import adams.core.License;

/**
 * An annotation for classes with the copyright belonging completely
 * to a third-party. I.e., a contribution without copyright assignment.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 4459 $
 */
public @interface ThirdPartyCopyright {
  String copyright() default "";
  String author() default "";
  License license() default License.TODO;
  String url() default "";
  String note() default "";
}
