/**
 * AbstractDatabaseConnectionBaselineCorrection.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.baseline;

import adams.data.container.DataContainer;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;

/**
 * Ancestor for baseline correction schemes that require database access.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3516 $
 * @param <T> the type of data container to process
 */
public abstract class AbstractDatabaseConnectionBaselineCorrection<T extends DataContainer>
  extends AbstractBaselineCorrection<T>
  implements DatabaseConnectionHandler {

  /** for serialization. */
  private static final long serialVersionUID = 2306902659179673256L;

  /** the database connection. */
  protected AbstractDatabaseConnection m_DatabaseConnection;

  /**
   * Initializes the members.
   */
  protected void initialize() {
    super.initialize();

    m_DatabaseConnection = getDefaultDatabaseConnection();
  }

  /**
   * Returns the default database connection.
   *
   * @return		the default database connection
   */
  protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

  /**
   * Returns the currently used database connection object, can be null.
   *
   * @return		the current object
   */
  public AbstractDatabaseConnection getDatabaseConnection() {
    return m_DatabaseConnection;
  }

  /**
   * Sets the database connection object to use.
   *
   * @param value	the object to use
   */
  public void setDatabaseConnection(AbstractDatabaseConnection value) {
    m_DatabaseConnection = value;
    updateDatabaseConnection();
    reset();
  }

  /**
   * Updates the database connection in dependent schemes.
   * <p/>
   * Default implementation does nothing.
   */
  protected void updateDatabaseConnection() {
  }
}
