/**
 * PrefixOnlyField.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */
package adams.data.report;

/**
 * Interface for fields that only have a prefix.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 */
public interface PrefixOnlyField
  extends Comparable {

  /**
   * Checks whether the name is a compound one.
   *
   * @return		true if name is a compound one
   */
  public boolean isCompound();

  /**
   * Returns the prefix for compound fields.
   *
   * @return		the prefix, null if not compound field
   */
  public String getPrefix();
}
