/**
 * Conditions.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import adams.core.ConsoleObject;
import adams.core.Properties;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.env.ConditionsDefinition;
import adams.env.Environment;

/**
 * Helper class for retrieving default conditions setups.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2815 $
 */
public class Conditions
  extends ConsoleObject {

  /** for serialization. */
  private static final long serialVersionUID = 1697740407123800323L;

  /** the name of the props file. */
  public final static String FILENAME = "Conditions.props";

  /** the singleton instance. */
  protected static Conditions m_Singleton;

  /** the properties file. */
  protected Properties m_Properties;

  /**
   * Initializes the object.
   */
  private Conditions() {
    super();

    m_Properties = Environment.getInstance().read(ConditionsDefinition.KEY);
  }

  /**
   * Returns the default setup for the given conditions object.
   *
   * @param cond	the conditions object to return the default setup for
   * @return		the default setup
   */
  public AbstractConditions getDefault(AbstractConditions cond) {
    AbstractConditions	result;
    String		classname;
    String[]		options;

    try {
      result    = cond.shallowCopy();
      classname = cond.getClass().getName();
      if (m_Properties.hasKey(classname)) {
	options = OptionUtils.splitOptions(m_Properties.getProperty(classname));
	ArrayConsumer.setOptions(result, options);
      }
    }
    catch (Exception e) {
      result = null;
      getSystemErr().printStackTrace(e);
    }

    return result;
  }

  /**
   * Returns the singleton instance. Instantiates it if necessary.
   *
   * @return		the singleton instance
   */
  public static synchronized Conditions getSingleton() {
    if (m_Singleton == null)
      m_Singleton = new Conditions();

    return m_Singleton;
  }
}
