/**
 * RenamingDataProvider.java
 * Copyright (C) 2010 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

/**
 * Interface for data providers that allow the renaming of data containers.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3507 $
 * @param <T> the type of the new name
 */
public interface RenamingDataProvider<T>
  extends DatabaseConnectionProvider {

  /**
   * Renames the data container.
   *
   * @param dbid	the database ID of the data container
   * @param newName	the new name
   * @return		null if successfully renamed, otherwise the error message
   */
  public String rename(int dbid, T newName);
}
