/**
 * SequenceProvider.java
 * Copyright (C) 2009 University of Waikato, Hamilton, New Zealand
 */
package adams.db;

import java.util.Hashtable;
import java.util.Vector;

import adams.data.sequence.XYSequence;

/**
 * Interface for classes that return XYSequences.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 417 $
 */
public interface SequenceProvider {

  /**
   * Reloads the templates.
   */
  public void refresh();

  /**
   * Retrieves sequence(s) from a given SQL statement.
   *
   * @param query	the statement to retrieve the sequences
   * @return		the sequence(s)
   */
  public Vector<XYSequence> retrieve(String query);

  /**
   * Retrieves sequence(s) from a given SQL statement.
   *
   * @param query	the statement to retrieve the sequences
   * @param nameX	the name of the column to use as x-axis, if null then
   * 			the first column will be used
   * @return		the sequence(s)
   */
  public Vector<XYSequence> retrieve(String query, String nameX);

  /**
   * Returns all the templates currently stored.
   *
   * @return		the templates (name &lt;-&gt; sql relation)
   */
  public Hashtable<String,String> getTemplates();
}
