/*
 * Environment.java
 * Copyright (C) 2009-2011 University of Waikato, Hamilton, New Zealand
 */

package adams.env;

import java.util.Arrays;
import java.util.Vector;

/**
 * Manages properties files and returns merged versions.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 2822 $
 */
public class Environment
  extends AbstractEnvironment {

  /** for serialization. */
  private static final long serialVersionUID = -2199293612498875147L;

  /**
   * Initializes the object.
   */
  protected Environment() {
    super();
  }

  /**
   * Returns the resource locations of the properties files with the definitions.
   *
   * @return		the resource locations
   */
  protected Vector<String> getPropertiesDefinitions() {
    return new Vector<String>(
	Arrays.asList(
	    new String[]{
		"adams/env/" + FILENAME
	    }));
  }

  /**
   * Returns the project's name.
   *
   * @return		the internal name of the project
   */
  public String getProject() {
    return Project.NAME;
  }
}
