/*
 * DatabaseConnectionChangeEvent.java
 * Copyright (C) 2008 University of Waikato, Hamilton, New Zealand
 */

package adams.event;

import javax.swing.event.ChangeEvent;

import adams.db.AbstractDatabaseConnection;


/**
 * Whenever a change in the database connection (connect/disconnect) happens,
 * the listeners get notified with this event.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 3484 $
 */
public class DatabaseConnectionChangeEvent
  extends ChangeEvent {

  /** for serialization. */
  private static final long serialVersionUID = -4819016430256498493L;

  /**
   * Enum for the type of event.
   *
   * @author  fracpete (fracpete at waikato dot ac dot nz)
   * @version $Revision: 3484 $
   */
  public enum Type {
    /** a general notification. */
    GENERAL,
    /** a connect happened. */
    CONNECT,
    /** a disconnect happened. */
    DISCONNECT;
  }

  /** the type of event. */
  protected Type m_Type;

  /**
   * Initializes the event.
   *
   * @param source	the database connection object
   * @param type	the type of event
   */
  public DatabaseConnectionChangeEvent(Object source, Type type) {
    super(source);

    m_Type = type;
  }

  /**
   * Returns the database connection object that triggered the event.
   *
   * @return		the responsible object
   */
  public AbstractDatabaseConnection getDatabaseConnection() {
    return (AbstractDatabaseConnection) getSource();
  }

  /**
   * The type of event.
   *
   * @return		the type
   */
  public Type getType() {
    return m_Type;
  }

  /**
   * Returns the event as string.
   *
   * @return		a string representation of the event
   */
  public String toString() {
    return getClass().getName() + ": type=" + getType() + ", dbc=" + getSource();
  }
}
